﻿# Du kannst das Skript für Dein Spiel in diese Datei schreiben.

# Unterhalb dieser Zeile kannst Du Bilder definieren, indem Du das Wort "image" verwendest
# z. B. image eileen happy = "eileen_happy.png"

# Erstelle hier Charaktere, die in Deinem Spiel auftauchen werden

init python:
    def callback_ayame(event, **kwargs):
        if event == "show":
            renpy.music.play("Undertale_generic_2.mp3", channel="sound")
        elif event == "slow_done" or event == "end":
            renpy.music.stop(channel="sound")

init python:
    def callback_ryuji(event, **kwargs):
        if event == "show":
            renpy.music.play("Undertale_asriel.mp3", channel="sound")
        elif event == "slow_done" or event == "end":
            renpy.music.stop(channel="sound")

define a = Character('Ayame', color="#ffffff", callback=callback_ayame)
define r = Character('Ryuji', color="#ffffff", callback=callback_ryuji)
define e1 = Character(
    None,
    window_background = None,

    what_size=35,
    what_outlines=[( 1, "#000000", 0, 0 )],
    what_xalign=0.5,
    what_textalign=0.5,
    what_layout='subtitle')

image snow1 = Fixed(SnowBlossom("gui/snow1.png", 30, xspeed=(7, 20), yspeed=(40, 80), start=30))
image snow2 = Fixed(SnowBlossom("gui/snow2.png", 30, xspeed=(7, 20), yspeed=(40, 80), start=30))


# Hier beginnt das Spiel.
label start:

    define gui.name_text_size = 40
    
    transform slightright:
        xalign 0.90
        yalign 1.0

    transform slightleft:
        xalign 0.10
        yalign 1.0
    
    play music "Amnesia - Conflict.mp3"
    show screen inventory_display_toggle

    e1 "{vspace=10}Verlassenes Fabrikgelände bei Abenddämmerung."
    e1 "{vspace=10}Die Sonne ist fast verschwunden, nur das fahle Licht der Taschenlampen durchdringt die Dunkelheit."
    e1 "{vspace=10}Alte Spinde, Schutt und vergessene Schatten umgeben sie."
    e1 "{vspace=10}Ayame und Ryuji schreiten vorsichtig über den knirschenden Boden."
    e1 "{vspace=10}Ihre Taschenlampen werfen tanzende Lichtkegel in alle Richtungen."
    
    scene bg steel mill
    show snow1
    show snow2
    with fade


    "{vspace=10}{i}(Ryuji hebt skeptisch den Fuß über ein verrostetes Rohr){/i}"

    show ryuji tease at center

    r "{vspace=10}Wenn ich heute Tetanus krieg, darfst du mir den Arm verbinden. Mit pinkem Verband. Nur fair."

    show ryuji tease dark at slightright
    show ayame tease at slightleft

    a "{vspace=10}Ich hab sogar Einhorn-Pflaster dabei. Für den Notfall. Und deinen Stolz."

    "{vspace=10}{i}(Ryujis Taschenlampe beginnt wild zu flackert und erlischt kurz.){/i}"

    show ayame tease dark at slightleft
    show ryuji usuell at slightright

    queue sound flashlight_clicking
    queue sound flashlight_clicking

    $ renpy.pause(1.5)
    
    r "{vspace=10}Ach verdammt...!"
    r "{vspace=10}Toll. Natürlich stirbt meine Lampe zuerst. Wahrscheinlich beleidigt, weil ich sie 'billig' genannt hab."
    "{vspace=10}{i}(Ryuji dreht sich zu Ayame){/i}"
    r "{vspace=10}Sag nicht, dass deine besser ist, sonst wein ich."

    show ryuji usuell dark at slightright
    show ayame flashlight at slightleft

    "{vspace=10}{i}(Ayame blendet ihn spaßhaft kurz ins Gesicht){/i}"
    a "{vspace=10}Meine hält."

    show ayame flashlight dark at slightleft
    show ryuji tease at slightright

    "{vspace=10}{i}(Ryuji grinst schief und schüttelt den Kopf){/i}"
    r "{vspace=10}Tja. Wenigstens hab ich Humor. Und du hast Erste Hilfe-Zeug. Wir ergänzen uns also super."

    show ryuji tease dark at slightright
    show ayame smile at slightleft

    a "{vspace=10}Das nenn ich Schicksal. Oder pures Chaos, eins von beidem."

    show ayame smile dark at slightleft

    "{vspace=10}{i}(Ryuji und Ayame gehen weiter. Das Gelände ist still, fast zu still.){/i}"
    "{vspace=10}{i}(Der Schein ihrer Lampen wandert über verrostete Spinde, zerbrochene Fensterscheiben und Staub.){/i}"

    show ayame smile dark at slightleft
    show ryuji neutral at slightright

    r "{vspace=10}Bist du dir sicher, dass es hier ist? Ich mein... außer Dreck und Spinnen seh ich nichts. Kein Zeichen von irgendwem."

    menu:

        "Ich... ich denke schon. Es sieht so aus wie in der Vision, aber...":
            jump choice1_uncertain
        
        "Ja, es ist hier! Es muss hier sein. Wenn wir zu spät sind, dann...":
            jump choice1_irritated

        "Ja. Es muss hier sein. Ich hab die Hallen wiedererkannt.":
            jump choice1_certain

    label choice1_uncertain:
        $ menu_flag = True

        show ryuji neutral dark at slightright
        show ayame think at slightleft

        a "{vspace=10}Ich... ich denke schon. Es sieht so aus wie in der Vision, aber... irgendwie fühlt es sich anders an."

        show ayame think dark at slightleft
        show ryuji usuell at slightright

        r "{vspace=10}Super. Genau das will man hören, wenn man durch ne potenzielle Todesfalle schleicht."
        r "{vspace=10}Dann hoffen wir mal, dass dein Instinkt nicht gerade nen schlechten Tag hat. Wenn wir am Ende einfach nur alten Schimmel retten, schwör ich, lach' ich."

        show ryuji usuell dark at slightright

        jump choice1_done

    label choice1_irritated:
        $ menu_flag = True

        show ryuji neutral dark at slightright
        show ayame irritated at slightleft

        a "{vspace=10}Ja, es ist hier! Es muss hier sein. Wenn wir zu spät sind, dann..."

        show ayame irritated dark at slightleft
        show ryuji neutral at slightright

        r "{vspace=10}Okay, okay. Ich hab nur gefragt."
        r "{vspace=10}Atmen, Ayame. Sonst kippt hier gleich nicht nur das Gebäude um."
        r "{vspace=10}Ich hab's verstanden. Dann sehen wir zu, dass wir nicht zu spät sind."

        show ryuji neutral dark at slightright

        jump choice1_done

    label choice1_certain:
        $ menu_flag = False

        show ayame stern at slightleft

        a "{vspace=10}Ja. Es muss hier sein. Ich hab die Hallen wiedererkannt."
        a "{vspace=10}Die Schatten, das Licht. Irgendwo in diesem Gebäude ist jemand gefangen... und wir sind nicht zu früh."

        show ayame stern dark at slightleft
        show ryuji think at slightright

        r "{vspace=10}Na gut... wenn du dir so sicher bist, dann geh ich mit."
        r "{vspace=10}Ich mein, du hast mich schon mal vor'm sicheren Ende gerettet - also steh ich wohl in deiner Schuld."

        jump choice1_done

    label choice1_done:

        show ryuji tease at slightright

        "{vspace=10}{i}(Ryuji tritt etwas näher){/i}"
        r "{vspace=10}Ausserdem... irgendwer muss ja auf dich aufpassen, wenn du dich wieder kopfüber in Ärger stürzt."

        show ryuji tease dark at slightright
        show ayame normal at slightleft

        a "{vspace=10}Ich stürze nicht. Ich... tauch strategisch ein."

        show ayame normal dark at slightleft
        show ryuji laugh at slightright

        r "{vspace=10}Klar. Und ich bin der Kaiser von Japan."

        show ryuji laugh dark at slightright
        show ryuji neutral at slightright

        r "{vspace=10}Aber ernsthaft... du meinst, hier drin ist jemand? Lebendig?"

        show ryuji neutral dark at slightright
        show ayame stern at slightleft

        a "{vspace=10}Ich weiß es nicht genau." 
        a "{vspace=10}Aber ich hab das Gefühl, die Zeit läuft. Und wir müssen sie einholen."

        show ayame stern dark at slightleft
        show ryuji normal at slightright

        r "{vspace=10}Na, super. Kein Druck. Ich hasse Rennen gegen die Zeit."
        "{vspace=10}{i}(Ryuji blickt in einen dunklen Gang){/i}"

        show ryuji normal dark at slightright
        show ryuji stern at slightright
        
        r "{vspace=10}Und gegen Spinnen. Warum sind's immer Spinnen?"

        show ryuji stern dark at slightright
        show ayame tease at slightleft
        
        a "{vspace=10}Die retten wir nicht. Die sind auf sich gestellt."

        show ayame tease dark at slightleft
        show ayame normal at slightleft

        a "{vspace=10}Aber wir sollten uns trotzdem gut umsehen. Vielleicht finden wir ja ein paar Hinweise auf die Täter."
        a "{vspace=10}Vielleicht sogar vom Opfer." 


        # Umgebung untersuchen!!


        hide ayame
        hide ryuji

        call screen interactive_background

        screen interactive_background():

            imagemap:
                idle "door"
                hover "door shiny"

                hotspot (1530, 260, 50, 470) action Jump ("door") alt "door"
        
        screen interactive_background_newspaper():

            imagemap:
                idle "newspaper"
                hover "newspaper shiny"

                hotspot (1510, 670, 70, 70) action Jump ("newspaper") alt "newspaper"

        label door:

            play sound door_opening
            show bg steel mill two

            call screen interactive_background_newspaper

        label newspaper:

            play sound paper
            show item newspaper
            if "newspaper" not in inventory_items:
                $ inventory_items.append("newspaper") 

            "{vspace=10}{i}Eine alte zerissene Zeitung. Das Papier ist bereits stark vergilbt, aber einiges ist noch lesbar.{/i}"

            hide item newspaper

            jump interactive_background_newspaper_done
        
    label interactive_background_newspaper_done:
                

        # Umgebunsuntersuchung fertig!


        show ryuji normal at center

        r "{vspace=10}Hey... das hier lag in einem der Spinde."

        show ryuji normal dark at slightright
        show ayame think at slightleft

        a "{vspace=10}Eine Zeitung?"

        show ayame think dark at slightleft
        show ryuji neutral at slightright

        r "{vspace=10}'Stahlwerk Kirishima - nach 43 Jahren geschlossen'..."
        r "{vspace=10}Wow. Ist also schon richtig alt. Und trotzdem stinkt's hier noch nach Öl."

        show ryuji neutral dark at slightright
        show ayame stern at slightleft

        "{vspace=10}{i}(Ayame nimmt ihm den Artikel ab, liest weiter. Plötzlich hält sie inne.){/i}"
        a "{vspace=10}Warte... hast du das gehört?"

        show ayame stern dark at slightleft
        show ryuji usuell at slightright

        r "{vspace=10}Was denn?"

        show ryuji usuell dark at slightright
        show ayame think at slightleft

        "{vspace=10}{i}(Ayame hebt den Zeigefinger an die Lippen.){/i}"
        a "{vspace=10}Still. Da war ein Geräusch. Klopfen. Ganz leise"

        "{vspace=10}Beide verharren. Das Licht ihrer Lampe wandert langsam über die Wände. Dann... ein dumpfer Laut. Zwei kurze Schläge. Dann einer."

        show ayame think dark at slightleft
        show ryuji stern at slightright

        r "{vspace=10}...Du hast recht. Da ist jemand."

        show ryuji stern dark at slightright
        show ayame stern at slightleft

        a "{vspace=10}Und er will gefunden werden."
    


    #Credits


    label end:
        scene white 
        "Herzlichen Glückwunsch, du hast das Beta-Spiel beendet!"
        
        jump credits

        label credits:
            scene black
            $ quick_menu = False
            window hide
            $ credits_speed = 40
            show theend:
                yanchor 0.5 ypos 0.5
                xanchor 0.5 xpos 0.5
            with dissolve 
            $ renpy.pause(3.0)
            hide theend
            show endcred at Move((0.5,1.3), (0.5,-3.5), credits_speed, repeat=False, bounce=False, xanchor="center", yachor="bottom")
            pause(credits_speed)
            scene black
            with dissolve
            show thanks:
                yanchor 0.5 ypos 0.5
                xanchor 0.5 xpos 0.5
            with dissolve
            $ renpy.pause(7.0)
            return

        init python:
            credits = [('Opening Theme', 'Rino'), ('Opening Theme', 'Manyo'), ('Opening Theme', 'Kaori Oda'), ('Produzent', 'Celina Naujokat'), ('Director', 'Celina Naujokat'), ('Story by', 'Celina Naujokat'), ('Written by', 'Celina Naujokat'), ('Art Director', 'Celina Naujokat'), ('Scenario', 'Celina Naujokat'), ('Supervision', 'Lynns Magic Worlds'), ('Concept Artist', 'Celina Naujokat'), ('Character Art', 'Celina Naujokat'), ('Prop Design', 'Celina Naujokat'), ('Background', 'Celina Naujokat'), ('Pogrammer', 'Celina Naujokat'), ('Assistant Programmers', 'Tom Zanner'), ('Assistant Programmers', 'Dennis Naujokat'), ('Mental Assistant', 'Michel Kiowski'), ('Music Composition', 'Manyo'), ('Music Composition', 'Little Wing'), ('Sounds', 'Pixabay'), ('Sounds', 'Toby Fox'), ('Special Thanks', 'AMNESIA Staff'), ('Special Thanks', 'Toby Fox'), ('Special Thanks', 'Family and Friends')]
            credits_s = "{size=80}Credits\n\n"
            c1 = ''
            for c in credits:
                if not c1==c[0]:
                    credits_s += "\n{size=30}" + c[0] + "\n"
                credits_s += "{size=50}" + c[1] + "\n"
                c1=c[0]
            credits_s += "\n{size=50}Engine\n{size=30}Ren'py\8.3.7"

        init:
            image endcred = Text(credits_s, text_align = 0.5)
            image theend = Text("{size=40}Das Ende", text_align = 0.5)
            image thanks = Text ("{size=40}Danke für's Spielen!", text_align=0.5)



    return